/*
  ImageMagick Exception Methods.
*/
#ifndef _MAGICK_ERROR_H
#define _MAGICK_ERROR_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
  Exception define definitions.
*/
#define ThrowBinaryException(code,reason,description) \
{ \
  if (image != (Image *) NULL) \
    (void) ThrowException(&image->exception,code,reason,description); \
  return(False); \
}
#define ThrowImageException(code,reason,description) \
{ \
  (void) ThrowException(exception,code,reason,description); \
  return((Image *) NULL); \
}
#define ThrowReaderException(code,reason,image) \
{ \
  if ((image) == (Image *) NULL) \
    (void) ThrowException(exception,code,reason,(char *) NULL); \
  else \
    { \
      (void) ThrowException(exception,code,reason,(image)->filename); \
      if (image->blob->type != UndefinedStream) \
        CloseBlob(image); \
      DestroyImageList(image); \
    } \
  return((Image *) NULL); \
}
#define ThrowWriterException(code,reason,image) \
{ \
  assert(image != (Image *) NULL); \
  (void) ThrowException(&(image)->exception,code,reason,(image)->filename); \
  if (image_info->adjoin) \
    while ((image)->previous != (Image *) NULL) \
      (image)=(image)->previous; \
  if (image->blob->type != UndefinedStream) \
    CloseBlob(image); \
  return(False); \
}

/*
  Exception typedef declarations.
*/
typedef void
  (*ErrorHandler)(const ExceptionType,const char *,const char *);

typedef void
  (*FatalErrorHandler)(const ExceptionType,const char *,const char *);

typedef void
  (*WarningHandler)(const ExceptionType,const char *,const char *);

/*
  Exception declarations.
*/
extern MagickExport const char
  *GetLocaleExceptionMessage(const ExceptionType,const char *),
  *GetLocaleMessage(const char *);

extern MagickExport ErrorHandler
  SetErrorHandler(ErrorHandler);

extern MagickExport FatalErrorHandler
  SetFatalErrorHandler(FatalErrorHandler);

extern MagickExport unsigned int
  ListLocaleInfo(FILE *,ExceptionInfo *),
  SetExceptionInfo(ExceptionInfo *,ExceptionType),
  ThrowException(ExceptionInfo *,const ExceptionType,const char *,const char *);

extern MagickExport void
  CatchException(const ExceptionInfo *),
  DestroyExceptionInfo(ExceptionInfo *),
  DestroyLocaleInfo(void),
  GetExceptionInfo(ExceptionInfo *),
  MagickError(const ExceptionType,const char *,const char *),
  MagickFatalError(const ExceptionType,const char *,const char *),
  MagickWarning(const ExceptionType,const char *,const char *);

extern MagickExport WarningHandler
  SetWarningHandler(WarningHandler);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
